<?php
    header("Content-Type: application/json");
    header("Access-Control-Allow-Origin: *");
    header("Access-Control-Allow-Methods: POST");
    header("Access-Control-Allow-Headers: Content-Type");

    include_once "../config/bd.php";

    $studentId = isset($_POST['studentId']) ? intval($_POST['studentId']) : 0;
    $courseId = isset($_POST['courseId']) ? intval($_POST['courseId']) : 0;
    $status = isset($_POST['status']) ? trim($_POST['status']) : '';
    $comment = isset($_POST['comment']) ? trim($_POST['comment']) : '';

    file_put_contents("php://stderr", "Datos recibidos para asistencia: " . json_encode($_POST) . "\n");

    if ($studentId === 0 || $courseId === 0 || $status === '') {
        echo json_encode([
            "success" => false,
            "message" => "Faltan datos obligatorios: studentId, courseId o status."
        ]);
        exit();
    }

    try {
        $stmt = $conn->prepare("
            INSERT INTO control (fecha_hora, estado, observacion, estudiantes_id_estudiantes, cuenta_id_cuenta)
            VALUES (NOW(), :status, :comment, :studentId, 1)
        ");

        $stmt->bindParam(":status", $status);
        $stmt->bindParam(":comment", $comment);
        $stmt->bindParam(":studentId", $studentId);

        $stmt->execute();

        echo json_encode([
            "success" => true,
            "message" => "Registro exitoso."
        ]);
    } catch(PDOException $e) {
        echo json_encode([
            "success" => false,
            "message" => "Error en el registrar: " . $e->getMessage()
        ]);
    }
?>
