<?php
    header("Content-Type: application/json");

    header("Access-Control-Allow-Origin: *");
    header("Access-Control-Allow-Methods: POST");
    header("Access-Control-Allow-Headers: Content-Type");

    include_once "../config/bd.php";

    $data = json_decode(file_get_contents("php://input"), true);

    file_put_contents("php://stderr", print_r($data, true));  
    file_put_contents("php://stderr", "Datos recibidos: " . json_encode($data) . "\n");

    if (!isset($data['username']) || !isset($data['password'])) {
        echo json_encode([
            "success" => false,
            "message" => "Usuario o contraseña no enviados"
        ]);
        exit();
    }

    $usuario = $data['username'];
    $clave = $data['password'];

    try {
        $stmt = $conn->prepare("SELECT * FROM cuenta WHERE usuario = :usuario AND estado = 1 LIMIT 1");
        $stmt->bindParam(":usuario", $usuario);
        $stmt->execute();

        if ($stmt->rowCount() > 0) {
            $row = $stmt->fetch(PDO::FETCH_ASSOC);
            
            if ($clave === $row['clave']) {
                echo json_encode([
                    "success" => true,
                    "message" => "Inicio de sesión correcto",
                    "data" => [
                        "id_cuenta" => $row['id_cuenta'],
                        "usuario" => $row['usuario'],
                        "encargados_id" => $row['encargados_id_encargados']
                    ]
                ]);
            } else {
                echo json_encode([
                    "success" => false,
                    "message" => "Contraseña incorrecta"
                ]);
            }
        } else {
            echo json_encode([
                "success" => false,
                "message" => "Usuario no encontrado o inactivo"
            ]);
        }
    } catch(PDOException $e) {
        echo json_encode([
            "success" => false,
            "message" => "Error: " . $e->getMessage()
        ]);
    }
?>
