<?php
    header("Content-Type: application/vnd.ms-excel");
    header("Content-Disposition: attachment; filename=planilla_curso.xls");
    header("Pragma: no-cache");
    header("Expires: 0");

    include_once "../config/bd.php";

    $data = json_decode(file_get_contents("php://input"), true);

    if (!isset($data['courseId']) || !isset($data['startDate']) || !isset($data['endDate'])) {
        echo "Faltan parámetros";
        exit();
    }

    $courseId = intval($data['courseId']);
    $startDate = $data['startDate'];
    $endDate = $data['endDate'];

    try {
        $stmt = $conn->prepare("
            SELECT e.nombre1, e.nombre2, e.apellido1, e.apellido2, a.fecha, a.status 
            FROM asistencia a
            INNER JOIN estudiantes e ON a.estudiantes_id_estudiantes = e.id_estudiantes
            WHERE a.cursos_id_cursos = :courseId
            AND a.fecha BETWEEN :startDate AND :endDate
            ORDER BY e.apellido1, e.nombre1, a.fecha
        ");
        $stmt->bindParam(":courseId", $courseId);
        $stmt->bindParam(":startDate", $startDate);
        $stmt->bindParam(":endDate", $endDate);
        $stmt->execute();
        $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

        echo "Nombre1\tNombre2\tApellido1\tApellido2\tFecha\tEstado\n";

        foreach ($rows as $row) {
            echo $row['nombre1'] . "\t" . $row['nombre2'] . "\t" . $row['apellido1'] . "\t" . $row['apellido2'] . "\t" . $row['fecha'] . "\t" . $row['status'] . "\n";
        }

    } catch(PDOException $e) {
        echo "Error: " . $e->getMessage();
    }
?>
